/**
* Copyright (C) 2012, Crestron Electronics, Inc.  All rights reserved.
* No part of this software may be reproduced in any form, machine or natural,
* without the express written consent of Crestron.
*
* \file     (See the name of this file).
* \brief    Manages h/w signals to the following items on the TST-600:
*           - Infrared (IR) transceiver.
*           - IR transmitter LEDs.
*           - IR detector/receiver.
* \detail   (None).
* \warning  (None).
* \note     (None).
* \author   Arto Kiremitdjian.
* \date     3/23/2012.
* \review   Richard Ting on 3/27/12: rev. 138457.
**/
#ifndef IRDHWSIGNALS_H_INCLUDED
#define IRDHWSIGNALS_H_INCLUDED

//-------------------------------------------------------------------------
// Include files.
#include <linux/workqueue.h>
#include <linux/i2c.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/fsl_devices.h>
#include "IrdI2cIF.h" // IrdI2cInterface.

//-------------------------------------------------------------------------
// Preprocessor defines.

//-------------------------------------------------------------------------
// Type definitions.

struct IRD_chip {
	struct IRD_platform_data *pdata;
	struct mutex		fs_mutex; /* Serialize control */
	struct i2c_client	*client;
	struct miscdevice 	*IRD_dev;
	struct work_struct 	Interrupt_work;
	struct work_struct 	WakeUp_work;
	struct work_struct 	WaitForAwake_work;

	int i2cInterfaceHandle;//struct IrdI2cInterface i2cInterface; // I2C interface to IR transceiver.
};



void hwSignalsCleanUp (struct IRD_chip* chip);

//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// For managing individual h/w signals.

int IoPower (struct IRD_chip *chip, int powerOn);
int Reset (struct IRD_chip *chip, int inReset);

//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

#endif // IRDHWSIGNALS_H_INCLUDED
